# -*- coding: UTF-8 -*-

import pickle

import torch
import torch.nn.functional as F


if __name__ == '__main__':
    data_path = "./data/data.pkl"
    with open(data_path, "rb") as f:
        data = pickle.load(f)

    x, y = data["x"], data["y"]
    data_len = len(x)
    train_data_len = int(data_len / 2.)
    x_train, x_test = x[:train_data_len], x[train_data_len:]
    y_train, y_test = y[:train_data_len], y[train_data_len:]

    W_LS = torch.linalg.inv(x_train.T @ x_train) @ x_train.T @ y_train

    loss = F.mse_loss(x_test @ W_LS, y_test)
    print("Test Loss:", loss.cpu().numpy())

